<?php
/*

Posts Navigation Function

*/
function dt_navigation($pages = '', $range = 2)
{
	$showitems = ($range * 2)+1; 

	global $paged;
	if(empty($paged)) $paged = 1;

	if($pages == '')
	{
		global $wp_query, $dt_blog_page_query;
		if (is_page_template('template-blog.php')) {
			$pages = $dt_blog_page_query->max_num_pages;
		}
		else $pages = $wp_query->max_num_pages;
		if(!$pages)
		{
		 $pages = 1;
		}
	} 	

	if(1 != $pages)
		{
		echo "<div class=\"pagenav\">";
		if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo; ".__('First', 'delicious')."</a>";
		if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo; ".__('Previous', 'delicious')."</a>";

		for ($i=1; $i <= $pages; $i++)
		{
			if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
				{
					 echo ($paged == $i)? "<span class=\"current\">".$i."</span>":"<a href='".get_pagenum_link($i)."' class=\"inactive\">".$i."</a>";
				}
		}

		if ($paged < $pages && $showitems < $pages) echo "<a href=\"".get_pagenum_link($paged + 1)."\">".__('Next', 'delicious')." &rsaquo;</a>";
		if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>".__('Last', 'delicious')." &raquo;</a>";
		echo "</div>\n";
		}
	}
?>